#!/usr/bin/perl -w

# ---------------------------------------------------------------------
# Revision 2.0					2001-05-06						Heyer
# 
# didcon converts the following filetypes to Bitmap-files:
# Diddle Scratch
# Diddle Index (named sketches)
# DiddleBug
#
# Program call: didcon.pl [-w] input output [name]
# -w: optional - asks for new name if file exists already
# input: path and filename of inputfile (c:\palm\my\backup\diddledb.pdb)
# output: path of outputfiles (c:\mypics)
# name: optional - filename-prefix (picasso -> picasso1.bmp picasso2.bmp...) 
#----------------------------------------------------------------------

if ($ARGV[0] =~ m/^-.*/){
	($option, $infile, $outfolder, $titelpref) =  @ARGV;
	if ($option ne "-w") {die ("Option $option unknown\n")};
	}
else {
	($infile, $outfolder, $titelpref) =  @ARGV;
	$option = ' ';
	}

$infile or die ("No inputfile defined\n");
$outfolder or die ("No path for outputfile\n");


$bmpheader = "\x{42}\x{4d}\x{be}\x{0c}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{3e}\x{00}\x{00}\x{00}\x{28}\x{00}\x{00}\x{00}\x{a0}\x{00}\x{00}\x{00}\x{a0}\x{00}\x{00}\x{00}\x{01}\x{00}\x{01}\x{00}\x{00}\x{00}\x{00}\x{00}\x{80}\x{0c}\x{00}\x{00}\x{c4}\x{0e}\x{00}\x{00}\x{c4}\x{0e}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{00}\x{ff}\x{ff}\x{ff}\x{00}";
 
open (INPUT,$infile) or die ("Could not open input file $infile\n");
binmode INPUT;
@diddle = <INPUT>;
close INPUT;

chdir "$outfolder" or die "Could not open outputfolder $outfolder";
print "Open folder $outfolder for output\n";

$diddle = join ('',@diddle);

$ditype = substr($diddle,0x3c,8);
if ($ditype eq 'IndxDIDL'){
	print "Converting Diddle Index\n";
	}
elsif ($ditype eq 'DataDIDL'){			
	print "Converting Diddle Scratch\n";
	$titelpref = "scratch" unless $titelpref; 
	}
elsif ($ditype eq 'DataDIDB'){			
	print "Converting DiddleBug\n";
	$titelpref = "didbug" unless $titelpref; 
	}	
else {print "No Diddle or DiddleBug File\n"; die;}

# number of pictures in 4Dh, address of first picture in 50h

for ($picnum=0; $picnum<ord substr($diddle, 0x4d ,1);$picnum++){
	my $pixel1='';
	my $pixel2='';
	my $pixel3='';

	$h_base = ord substr($diddle, 0x50 + 8*$picnum ,1);
	$l_base = ord substr($diddle, 0x50 + 8*$picnum + 1 ,1);
	$loc = $h_base*256 + $l_base;

	$i=0;
	$picsize=0;
	
	if ($ditype eq 'DataDIDB'){							# decompress diddlebug
		do {
			$cptr = ord substr($diddle, $loc+107+$i, 1);
			if ($cptr &  0x80){
				$num_bytes = $cptr & 0x3f;
				$num_bytes++;
				if ($cptr & 0x40) {
					$pixel1 .= substr($diddle, $loc+$i+107+1, $num_bytes);	# mixed
					$i += $num_bytes;
					}
				else {
					$pixel1 .= chr(0xFF) x $num_bytes;						# black
					}
				}
			else {
				$num_bytes = $cptr & 0x7f;
				$num_bytes++;
				$pixel1 .= chr(0x00) x $num_bytes;							# white
			}
		$picsize += $num_bytes;
		$i++;
		} while ($picsize<3200);
		
	}
	
	else {$pixel1 = substr($diddle,$loc, 3200);}  		#get single picture

	for ($i=0; $i<3200; $i=$i+20){						#turn upside down
		$line = substr($pixel1, $i, 20);
		$pixel2 = $line . $pixel2;
	}


	for ($i=0; $i<3200; $i++){							#reverse pixel colour
		$byte = substr($pixel2, $i, 1);
		$byte2 = 255 - ord $byte;
		$pixel3 .= chr($byte2);
	}

	$bild = $bmpheader . $pixel3;						#add bmp-fileheader

 	if (!$titelpref && $ditype eq 'IndxDIDL') {
		$titel = substr($diddle, $loc+3200, 28);  		#picture title
 		$titel =~ s/[^\w\d]/_/g;
		$titel =~ s/_*\Z//;
		}
	
	else {
		$j = $picnum + 1;
		$titel = "$titelpref$j";
		}
	
	$titel .= ".bmp";									#filename
	
	while (open (OUTPUT,$titel) && $option eq "-w"){
		print"$titel exists already - input new name or overwrite (return only):\n";
		chomp ($eing = <STDIN>);	
		 if ($eing) {$titel = $eing;}
		 else {last;}
		}
	
	print "Save $titel\n";
	open (OUTPUT,">$titel") or die ("Could not open output file $titel\n");
	binmode OUTPUT;
	print OUTPUT "$bild";								#save file
	close OUTPUT;
}